/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.Hashtable;

public class VWWorkBasketFilterDefinition
extends VWMLABase
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7449L;
    public static final int OPERATOR_EQUAL = 0;
    public static final int OPERATOR_NOT_EQUAL = 1;
    public static final int OPERATOR_GREATER_THAN = 2;
    public static final int OPERATOR_GREATER_THAN_OR_EQUAL = 3;
    public static final int OPERATOR_LESS_THAN = 4;
    public static final int OPERATOR_LESS_THAN_OR_EQUAL = 5;
    public static final int OPERATOR_LIKE = 6;
    public static final int OPERATOR_NOT_LIKE = 7;
    protected static final int OPERATOR_NULL = 8;
    protected static final int OPERATOR_NOT_NULL = 9;
    protected transient VWWorkBasketDefinition m_myWorkBasketDef = null;
    protected String m_name = null;
    private String m_description = null;
    private String m_prompt = null;
    private VWExposedFieldDefinition m_searchField = null;
    private int m_operator = 0;
    private String m_orbFieldName = null;
    private int m_type = -1;
    protected Hashtable m_attributes = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:22:06 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    protected VWWorkBasketFilterDefinition(String name, VWWorkBasketDefinition workBasketDef) throws VWException {
        if (workBasketDef == null) {
            throw new VWException("vw.api.VWWorkBasketFilterDefErr", "The in-basket definition object can not be null");
        }
        if (name == null || name.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketFilterDefNameErr", "The in-basket name can not be null or empty");
        }
        this.setMyWorkBasketDefinition(workBasketDef);
        this.setName(name);
        this.setHasChanged(true);
    }

    protected VWWorkBasketFilterDefinition(String name, String description, String prompt, String searchFieldName, int _operator, VWAttributeInfo attributes) throws VWException {
        this.m_name = name;
        this.m_description = description;
        this.m_prompt = prompt;
        this.m_orbFieldName = searchFieldName;
        this.m_operator = _operator;
        this.setAttributeInfo(attributes);
    }

    protected void setMyWorkBasketDefinition(VWWorkBasketDefinition wbDef) throws VWException {
        this.m_myWorkBasketDef = wbDef;
        if (wbDef != null) {
            super.setSession(wbDef.getSession());
        }
    }

    public String getName() throws VWException {
        return this.translateStr(this.m_name);
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.m_name);
    }

    public void setName(String theName) throws VWException {
        if (theName != null) {
            theName = theName.trim();
        }
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinitionInvalidName", "The in-basket filter name is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinitionNameTooLong", "The in-basket filter name can not exceed 128 characters).");
        }
        if (theName.startsWith("~")) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinitionName.InvalidSartChar", "The in-basket filter name can not start with ''~''.");
        }
        if (this.m_myWorkBasketDef.getWorkBasketFilterDefinition(theName) != null) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinition.workbasketFilterAlreadyExists", "An in-basket filter definition with that name already exists.");
        }
        this.m_name = theName;
        this.setHasChanged(true);
    }

    public String getDescription() throws VWException {
        if (this.m_description != null) {
            return this.translateStr(this.m_description);
        }
        return null;
    }

    public void setDescription(String description) throws VWException {
        this.m_description = description;
        this.setHasChanged(true);
    }

    public String getPrompt() throws VWException {
        if (this.m_prompt != null) {
            return this.translateStr(this.m_prompt);
        }
        return null;
    }

    public void setPrompt(String label) throws VWException {
        this.m_prompt = label;
        this.setHasChanged(true);
    }

    public int getType() throws VWException {
        if (this.m_type != -1) {
            return this.m_type;
        }
        if (this.m_searchField != null) {
            return this.m_searchField.getFieldType();
        }
        return -1;
    }

    public VWExposedFieldDefinition getSearchField() throws VWException {
        return this.m_searchField;
    }

    protected String getRuntimeSearchFieldName() {
        return this.m_orbFieldName;
    }

    public void setSearchField(VWExposedFieldDefinition field, int operator) throws VWException {
        if (field == null) {
            this.m_searchField = null;
            this.m_operator = 0;
            this.m_type = -1;
            this.setHasChanged(true);
        } else if (VWWorkBasketFilterDefinition.validateOperator(field.getFieldType(), operator)) {
            this.m_searchField = field;
            this.m_operator = operator;
            this.m_type = this.m_searchField.getFieldType();
            this.setHasChanged(true);
        }
    }

    public int getOperator() throws VWException {
        return this.m_operator;
    }

    public void setOperator(int op) throws VWException {
        if (this.m_searchField == null) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinition.CantSetOperator.searchFieldIsNull", "Failed to set the operator - the current search field is null");
        }
        if (VWWorkBasketFilterDefinition.validateOperator(this.m_searchField.getFieldType(), op)) {
            this.m_operator = op;
            this.setHasChanged(true);
        }
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.m_attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.m_attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
        this.setHasChanged(true);
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.m_attributes = theAttributes;
    }

    public String toString() {
        return this.m_name;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void setHasChanged(boolean theNewValue) throws VWException {
        if (this.m_myWorkBasketDef != null) {
            this.m_myWorkBasketDef.setHasChanged(theNewValue);
        }
    }

    protected Object clone() {
        try {
            VWWorkBasketFilterDefinition workBasketFilterDef = (VWWorkBasketFilterDefinition)super.clone();
            if (this.m_attributes != null) {
                workBasketFilterDef.m_attributes = (Hashtable)this.m_attributes.clone();
            }
            return workBasketFilterDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void initSearchFieldFromORB() throws VWException {
        if (this.m_orbFieldName != null && this.m_orbFieldName.length() > 0) {
            this.m_searchField = this.m_myWorkBasketDef.m_myQueueDef.getExposedField(this.m_orbFieldName);
            this.m_orbFieldName = null;
        }
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkBasketFilterDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "InBasketFilterDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_name) + "\"\n");
        if (this.m_description != null) {
            theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.m_description) + "\"\n");
        }
        if (this.m_prompt != null) {
            theBuffer.append(INDENT_1 + "Prompt" + "=\"" + VWXMLHandler.toXMLString(this.m_prompt) + "\"\n");
        }
        if (this.m_searchField != null) {
            theBuffer.append(INDENT_1 + "SearchField" + "=\"" + VWXMLHandler.toXMLString(this.m_searchField.getName()) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Operator" + "=\"" + this.getOperator() + "\"");
        theBuffer.append(">\n");
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        if (theAttributeInfo != null) {
            theAttributeInfo.toXML(theBuffer, INDENT_1);
        }
        theBuffer.append(INDENT_0 + "</" + "InBasketFilterDefinition" + ">\n");
    }

    protected void removeReferences() {
        this.m_name = null;
        this.m_description = null;
        this.m_myWorkBasketDef = null;
        this.m_prompt = null;
        this.m_searchField = null;
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_attributes = null;
    }

    protected static boolean validateOperator(int fieldType, int operator) throws VWException {
        boolean bValid = false;
        switch (fieldType) {
            case 2: {
                if (operator != 0 && operator != 1 && operator != 2 && operator != 3 && operator != 4 && operator != 5 && operator != 6 && operator != 7) break;
                bValid = true;
                break;
            }
            case 4: {
                if (operator != 0 && operator != 1) break;
                bValid = true;
                break;
            }
            default: {
                if (operator != 0 && operator != 1 && operator != 2 && operator != 3 && operator != 4 && operator != 5) break;
                bValid = true;
            }
        }
        if (!bValid) {
            String typeName = VWFieldType.getLocalizedString(fieldType);
            throw new VWException("vw.api.VWWorkBasketFilterDefinition.InvalidOperator", "Operator ({0}) is not valid for field type {1}", Integer.toString(operator), typeName);
        }
        return bValid;
    }

    protected void setType(int type) {
        this.m_type = type;
    }
}

